
// Simple QuickBASIC-like syntax highlighter (no dependencies)
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('pre code.language-vbscript, pre code.language-basic').forEach(function(block) {
        let code = block.textContent;

        // Patterns
        const keywords = /\b(DECLARE|FUNCTION|SUB|END|IF|THEN|ELSE|ELSEIF|FOR|TO|NEXT|DO|LOOP|WHILE|WEND|SELECT|CASE|DIM|AS|BYVAL|INTEGER|STRING|LONG|SINGLE|DOUBLE|AND|OR|NOT|XOR|MOD|CONST|SHARED|STATIC|TYPE|REM|PRINT|INPUT|OPEN|CLOSE|REDIM|ERASE|OPTION|BASE|DEFINT|DEFSNG|DEFDBL|DEFSTR|CALL|GOSUB|GOTO|RETURN|EXIT|STEP|UNTIL|BYREF|LET)\b/gi;
        const comments = /(^|\s)(REM\s.*$|'.*$)/gim;
        const strings = /"[^"]*"/g;
        const numbers = /\b(\d+(\.\d+)?|&H[0-9A-F]+|&O[0-7]+)\b/gi;
        const builtins = /\b(INKEY\$|STR\$|CHR\$|MID\$|LEFT\$|RIGHT\$|UCASE\$|LCASE\$|LTRIM\$|RTRIM\$|SPACE\$|STRING\$|LEN|VAL|ASC|INSTR|VARSEG|VARPTR|PEEK|POKE|INT|FIX|ABS|SGN|SQR|SIN|COS|TAN|ATN|LOG|EXP|RND|TIMER|SCREEN|CLS|LOCATE|COLOR|SOUND|PLAY|BEEP|DQB\w+\$?)\b/gi;

        // Escape minimal HTML
        code = code.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');

        // Order: comments first to avoid inside matching
        code = code.replace(comments, function(_, p1, p2){ return p1 + '<span class="comment">' + p2 + '</span>'; });
        code = code.replace(strings, '<span class="string">$&</span>');
        code = code.replace(numbers, '<span class="number">$&</span>');
        code = code.replace(keywords, '<span class="keyword">$&</span>');
        code = code.replace(builtins, '<span class="builtin">$&</span>');

        block.innerHTML = code;
    });
});
